/*************************************************************************
* A do file to produce all of the results in SWZ06 - 			 *
* "Partisan Impacts on the Economy: Evidence From Prediction Markets	 *
* and Close Elections							 *
* Requires 3 data files:						 *
* SWZ06_1.dta - data from election day 2004 (Table 1, Figure 1)		 *
* SWZ06_1.dta - data from leadup to election 2004 (Table 3)		 *
* SWZ06_1.dta - historical data (Table 5, Figures 3-4)			 *
*************************************************************************/

#delimit;
drop _all;
set more 1;
capture log close;
log using SWZ06_results.log, replace;
log off;

/*************************************************************************
* Table 1								 *
*************************************************************************/
cap log on;
foreach sym in logES logDOW logNQ logTW baCLAZ04 baCLAZ05 baCLAZ06 yBtwo yBten {;
	/* 10 min lag */
	cap use SWZ06_1.dta, clear;
	cap gen i = 1;
	cap replace i = i[_n-1]+1 if `sym'[_n-1] == .;
	/* w is the weight to get rid of heteroskedacticity */
	cap gen w = 1/i;
	cap gen double delta`sym' = `sym' - `sym'[_n-i];
	cap gen double deltaGW = gwbush[_n] - gwbush[_n-i];
	reg delta`sym' deltaGW [aweight = w], robust;
	cap drop w deltaGW delta`sym';

	/* 30 - min lags */
	cap sort date hour m10;
	cap replace `sym' = `sym'[_n-i] if `sym' == . & i <= 2;
	cap gen o = mod(_n,3);
	cap keep if o == 1;
	drop o i;
	cap sort date hour m10;
	cap gen i = 1;
	cap replace i = i[_n-1]+1 if `sym'[_n-1] == .;
	/* w is the weight to get rid of heteroskedacticity */
	cap gen w = 1/i;
	/* 30 - min diff */
	cap gen double delta`sym' = `sym' - `sym'[_n-i];
	cap gen double deltaGW = gwbush[_n] - gwbush[_n-i];
	reg delta`sym' deltaGW [aweight = w], robust;
};
/* Get data for figure 1 */
use SWZ06_1.dta, clear;
outfile date hour m10 gwbush pES using SWZ06_1.csv, comma replace;

/*************************************************************************
* Table 3								 *
*************************************************************************/
use SWZ06_2, clear;
gen n = _n;
tsset n;
/* for estimation in text */
newey s.gwbush s.logES, lag(1);
/* to get r-squared */
reg s.gwbush s.logES;

foreach sym in logES logDOW logNQ logTW yBten {;
newey s.`sym' s.gwbush, lag(1);
newey s5.`sym' s5.gwbush, lag(5);
newey s20.`sym' s20.gwbush, lag(20);
};

/* 3 gaps, newey can't do this */
drop if pOIL == .;
replace n = _n;
tsset n;
newey s.pOIL s.gwb, lag(1);
newey s5.pOIL s5.gwb, lag(5);
newey s20.pOIL s20.gwb, lag(20);

/*************************************************************************
* Table 5								 *
*************************************************************************/
use SWZ06_3, clear;

reg schwertreturn gopwin if year>=1928 & year<=1996;
reg schwertreturn gopshock if year>=1928 & year<=1996;
reg schwertreturn gopshock;
reg schwertreturn gopshock incshock;

/* figures commented out so they won't appear unless you want them 
/*************************************************************************
* Figure 3								 *
*************************************************************************/
twoway 
	(lfit schwertreturn gopshock, sort lcolor(black)) 
	(scatter schwertreturn gopshock if year<2000, mcolor(navy) msymbol(circle) mlabel(label) mlabsize(vsmall) mlabcolor(green) mlabposition(12))
	(scatter schwertreturn gopshock if year>=2000, mcolor(red) msymbol(square) mlabel(label) mlabsize(small) mlabcolor(black) mlabposition(3)),
	ytitle("Stock Return: Value-weighted index" "Pre-election close to Post-election close") 
	ylabel(, angle(horizontal)) 
	xtitle("Shock to Probability of a Republican President" "I(Republican President) - Pre-election prediction market price") 
	xlabel(-1(0.25)1, labgap(3)) 
	xmlabel( .75 "Shock Republican win" .25 "Expected Rep. win" -.25 "Expected Dem. win"  -.75 "Shock Democrat Win", labgap(1) labsize(small))
	title("Equity Market Responses to Electoral Shocks: 1880-2004")
	legend(off)
	xsize(10)
	ysize(7.5)
;

/*************************************************************************
* Figure 4								 *
*************************************************************************/
/* for equation at bottom of figure 4 */
gen post1980=year>=1980;
xi: reg ychange i.post1980*gopshock;

twoway 
	(lfit ychange gopshock, sort lcolor(black)) 
	(scatter ychange gopshock, mcolor(navy) msymbol(circle) mlabel(label) mlabsize(vsmall) mlabcolor(green) mlabposition(12))
	if year<1980
,
	ylabel(, angle(horizontal)) 
	xlabel(-1(0.25)1) 
	xtitle("")
	title("Pre-Reagan: 1892-1976")
	legend(off)
	xsize(10)
	ysize(7.5)
	name(bond1, replace)
;
twoway 
	(lfit ychange gopshock, sort lcolor(black)) 
	(scatter ychange gopshock, mcolor(navy) msymbol(circle) mlabel(label) mlabsize(vsmall) mlabcolor(green) mlabposition(12))
	if year>=1980
,
	ylabel(, angle(horizontal)) 
	xlabel(-1(0.25)1)
	xtitle("") 
	title("Since Reagan: 1980-2004")
	legend(off)
	xsize(10)
	ysize(7.5)
	name(bond2, replace)
;
#delimit ;
graph combine bond1 bond2, 
	xcommon ycommon
	l1title("Change in Long Bond Yields (Basis Points)" "Pre-election close to Post-election close") 
	b1title("Shock to Probability of a Republican President" "I(Republican President) - Pre-election prediction market price") 
	title("Bond Market Responses to Electoral Shocks")
	note("Change in bond yields = 0.03 + 1.48*Post_1980 + Change in prob(Republican)*(0.05 + 12.79*Post_1980)"
	      "                                        (0.91) (2.31)                                                                   (2.60)   (8.51)      R-sq=0.23", pos(7))
	caption("Note: Chart shows estimate of bond market reaction for 2004 estimated from Table 1", size(vsmall))
;
*/


log close;

